function [x4,time]=f__simul(rule,sd,set,wst)

%f__simul
%         [x4,time]=f__simul(rule,sd,set,wst)
%         f__simul is the main simulation procedure

% B.Kaempf , S.Molt. 28.2.93

% initialization
% --------------
[xneu, x2, x4, delta,...
 theta_soll, theta_merk, time,...
 Rs, Sp]  =  f__init(rule,sd,set);



% time-loop to calculate the states
% ---------------------------------
i=1;
while (i<2000)

% if you haven't got a powerful machine like a 486 (or better) this loop may
% take quite a while;
% therefore each time-step i and the element of the state-vector (theta) is 
% printed on the screen

	i
	theta=r2d(xneu(4))

%	DEFINITION OF FUZZY-INPUT-VECTOR Y
        y(2)=1.5*(r2d(xneu(4))-theta_merk);
	y(1)=2*( r2d(xneu(4)) - theta_soll );
	
	theta_merk=r2d(xneu(4));

%	CALL THE FUZZY-CONTROLLER
	uc=f__fc(rule,sd,set,Rs,Sp,y);  
	u__st=d2r(uc);

%	print uc to show some information
	uc


%	CALCULATE THE NEW STATE X
	xneu=f__state(xneu,d2r(uc));
	

%	ADD THIS VALUE TO THE VECTOR x_i SO YOU CAN EASILY PLOT IT
	x4=[x4,r2d(xneu(4))];
	x2=[x2,xneu(2)];
	time=[time,i];

%	As i have said above this simulation will take it's time on a
%	machine smaller than a 486.
%	To save your calculated data the following lines are helpful - they
%	will save your data for i=10, i=20, i=30 and so on. In this case a
%	power failure won't be that bad.

	i=i+1;  
	if( round(i/10)==i/10)
             save ergo5 x2 x4 time;
	end
end
