function [Temp,time]=f__simul(rule,sd,set)

%  [Temp,time]=f__simul(rule,sd,set)
%  
%  main simulation procedure

%  initialization
[Temp,T,...
 ad,bd,T_aus,P0,...
 Rs,Sp,...
 T_soll, T_merk, time,timerange] = f__init(rule,sd,set);


%  time-loop to calculate the states
i=time(1);
while (i < timerange)

% if you haven't got a powerful machine like a 486 (or better) this loop may
% take quite a while;
% therefore each time-step i and the element of the state-vector is 
% printed on the screen



%	DEFINITION OF FUZZY-INPUT-VECTOR Y
	
        y(2)=(T-T_soll);		% state error
	y(1)=10*(T - T_merk) ;		% estimation of temperatur slope
	T_merk=T;
      
        i
	T

%	CALL FUZZY-CONTROLLER
        uc=f__fc(rule,sd,set,Rs,Sp,y); % slope of power

        uc

        
%	CALCULATE THE NEW STATE X
%	discrete simulation with dt=0.1 for 1 second
        for j=1:10
           P0=P0+uc;
	   theta=T-T_aus;
	   theta=f__state(theta,P0,ad,bd);
	   T=theta+T_aus;
        end
	
        P0
	
%	ADD THIS VALUE TO THE VECTOR x_i SO YOU CAN EASILY PLOT IT
	Temp=[Temp,T];
	time=[time,i];


%	As i said above this simulation will take it's time on a
%	machine smaller than a 486.
%	To save your calculated data the following lines are helpful - they
%	will save your data for i=10, i=20, i=30 and so on. In this case a
%	power failure won't be that bad.

        if (i/10==round(i/10))
           save t12345 Temp time
        end
	i=i+1;  
end
