function [x_t,x0,...
	  ad,bd,T_aus,P0,...
	  Rs,Sp,...
	  xcom, xmerk, time0,timerange] = f__init(rule,sd,set)

% initialization-procedure
% the initial values of the state-vector are set in this procedure
% if you want to use the unfuzzy2-method you have to calculate the
% matrices Rs and Sp (see last line) - if not you can uncomment this line

%  Constant plant parameters
F=98;			            	  % Surface
alpha=4;		              % Heat-transfer-coeff.
m=54;				              % mass of air
c=100;				            % specific Heat-capacity
ad=exp(-F*alpha*0.1/m/c);	% resulting 'system-matrix'
bd=(1-ad)/m/c;			      % resulting 'input-matrix'

T_aus=10;			            % temp of the surrounding medium
P0=40000;			            % Initial power of heating (as 'u(t=0)')



% Initial conditions
x0=15;		               % initial temperature
xmerk=15; 	             % additional value to calculate
                         %  initial temperature slope
x_t=[x0];	               % initializing the temp-vector over time t with x0
time0=[0];	             % initializing the time-vector with t=t0=0

timerange=200;         	 % Simulation over 200 seconds

% The goal of the controller:
xcom=20;		             % command temperature


% FOR UNFUZZY2
% initializing parameters needed for unfuzzy2
[Rs,Sp]=prepare(set,sd,rule);
