%	This file is to be called from fis1.m.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-4-93.

echo on;

% Now you can see the effects of changing parameter a's ...
echo off;
pp;

for t=0:0.1:20,
	a1 = 2.5*sin(t) + 3.5;
	a2 = 2.5*sin(t+2*pi/3) + 3.5;
	a3 = 2.5*sin(t+4*pi/3) + 3.5;
	mf1 = bell(x, a1, b1, c1);
	mf2 = bell(x, a2, b2, c2);
	mf3 = bell(x, a3, b3, c3);
	set(h1(1), 'ydata', mf1);
	set(h1(2), 'ydata', mf2);
	set(h1(3), 'ydata', mf3);

	weight_total = mf1 + mf2 + mf3;
	normalized_w1 = mf1./weight_total;
	normalized_w2 = mf2./weight_total;
	normalized_w3 = mf3./weight_total;
	set(h2(1), 'ydata', normalized_w1);
	set(h2(2), 'ydata', normalized_w2);
	set(h2(3), 'ydata', normalized_w3);

	maxi = max(max(mf1, mf2), mf3);
	index1 = find(mf1 ~= maxi);
	tmp1 = out1; tmp1(index1) = NaN*zeros(size(index1));
	index2 = find(mf2 ~= maxi);
	tmp2 = out2; tmp2(index2) = NaN*zeros(size(index2));
	index3 = find(mf3 ~= maxi);
	tmp3 = out3; tmp3(index3) = NaN*zeros(size(index3));
	set(h3(1), 'ydata', tmp1);
	set(h3(2), 'ydata', tmp2);
	set(h3(3), 'ydata', tmp3);

	normalized_out1 = out1.*normalized_w1;
	normalized_out2 = out2.*normalized_w2;
	normalized_out3 = out3.*normalized_w3;
	set(h4(1), 'ydata', normalized_out1);
	set(h4(2), 'ydata', normalized_out2);
	set(h4(3), 'ydata', normalized_out3);

	overall_out = normalized_out1 + normalized_out2 + normalized_out3;
	set(h5(1), 'ydata', tmp1);
	set(h5(2), 'ydata', tmp2);
	set(h5(3), 'ydata', tmp3);
	set(h5(4), 'ydata', overall_out);
end
