%	Demo file

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-4-93.
 
echo on;
clc;

% This file shows the behavior of a single input single output (SISO) 
% fuzzy inference system as the parameter b's of MF's are changing.

% First plot: 3 MF's defined by the generalized bell function
% Second plot: normalized MF's, defined as MF/(sum of all MF's).
% Third plot: output (a linear function) of each rule.
% Fourth plot: normalized output of each rule, defined as the
%              product of output and the corresponding normalized MF.
% Fifth plot: each rule's output and the overall output. 

echo off;

clf;
set(gcf, 'position', [12 12 560 960]);
x = (-9:0.2:9)';
a1 = 4; b1 = 2; c1 = -8;
a2 = 4; b2 = 2; c2 = 0;
a3 = 4; b3 = 2; c3 = 8;
mf1 = bell(x, a1, b1, c1);
mf2 = bell(x, a2, b2, c2);
mf3 = bell(x, a3, b3, c3);
mf = [mf1 mf2 mf3];
subplot(511); h1 = plot(x,mf);
axis([min(x) max(x) 0 1]);
set(h1, 'erasemode', 'background');
title('MF''s (weights)');

weight_total = mf1 + mf2 + mf3;
normalized_w1 = mf1./weight_total;
normalized_w2 = mf2./weight_total;
normalized_w3 = mf3./weight_total;
normalized_w = [normalized_w1 normalized_w2 normalized_w3];
subplot(512); h2 = plot(x,normalized_w);
axis([min(x) max(x) 0 1]);
set(h2, 'erasemode', 'background');
title('normalized weights');

p1 = 1; q1 = 6;
p2 = 2; q2 = 1;
p3 = -1; q3 = -2;
out1 = p1*x + q1;
out2 = p2*x + q2;
out3 = p3*x + q3;
maxi = max(max(mf1, mf2), mf3);
index1 = find(mf1 ~= maxi);
tmp1 = out1; tmp1(index1) = NaN*zeros(size(index1));
index2 = find(mf2 ~= maxi);
tmp2 = out2; tmp2(index2) = NaN*zeros(size(index2));
index3 = find(mf3 ~= maxi);
tmp3 = out3; tmp3(index3) = NaN*zeros(size(index3));
tmp = [tmp1 tmp2 tmp3];
subplot(513); h3 = plot(x, tmp);
set(h3, 'erasemode', 'xor');
title('output of each rule');

normalized_out1 = out1.*normalized_w1;
normalized_out2 = out2.*normalized_w2;
normalized_out3 = out3.*normalized_w3;
normalized_out = [normalized_out1 normalized_out2 normalized_out3];
subplot(514); h4 = plot(x, normalized_out);
set(h4, 'erasemode', 'xor');
title('normalized output of each rule');

overall_out = normalized_out1 + normalized_out2 + normalized_out3;
subplot(515); h5 = plot(x, tmp, x, overall_out, 'o');
set(h5, 'erasemode', 'xor')
title('overall output (''o'' curve)');

drawnow

global change_a change_b change_c change_output

% change_a, change_b, etc. are defined in demo.m.
if change_a == 1,
	fis1_a;
elseif change_b == 1,
	fis1_b;
elseif change_c == 1,
	fis1_c;
elseif change_output == 1,
	fis1_output;
else
	error('error in fis1.m!');
end

% reset
change_a = 0;
change_b = 0;
change_c = 0;
change_output = 0;
