%	Animation of membership functions composed of two sigmoid functions.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	6-5-93.
%	7-9-93, add the plot of product

echo on;
clc;

% This file shows how the animation of two sigmoidal functions and their
% difference.

echo off;

clg;
set(gcf, 'position', [10 344 560 620]);

x = (-10:0.2:10)';
% An arbitrary plot
subplot(311); h1 = plot([-10, 10], [0 1; 1 0; 1 1]);
set(h1,'erasemode','background')
% To initialize the xlabel and title field of current axes
xlabel(''); title('');
axis([-10 10 0 1]);
% If not initialized previously, t1 and t2 will be NULL
t1 = get(gca, 'xlabel'); set(t1, 'EraseMode', 'background');
t2 = get(gca, 'title'); set(t2, 'EraseMode', 'background');

subplot(312); h2 = plot([-10,10],[0 1], 'r-', [-10,10], [0 1], 'co');
axis([-10 10 0 1]);
xlabel('abs. of diff. of two sigmoidal curves');
set(h2,'erasemode','xor')

subplot(313); h3 = plot([-10,10],[0 1], 'g-', [-10,10], [0 1], 'yo');
axis([-10 10 0 1]);
xlabel('product of two sigmoidal curves');
set(h3,'erasemode','xor')

for i=0:0.02:10,
	if i == 0,
		set(h1(1), 'XData', x)
		set(h1(2), 'XData', x)
		set(h2(1), 'XData', x)
		set(h2(2), 'XData', x)
		set(h3(1), 'XData', x)
		set(h3(2), 'XData', x)
	end
	a1 = 4*sin(i);
	c1 = 8*cos(i);
	a2 = 4*sin(i+pi/2);
	c2 = -8*cos(i);
	y1 = sigmoid(x, a1, c1);
	y2 = sigmoid(x, a2, c2);
	y3 = abs(y2 - y1);
	y4 = y1.*y2;
	set(h1(1), 'YData', y1)
	set(h1(2), 'YData', y2)
	set(h2(1), 'YData', y3)
	set(h2(2), 'YData', y3)
	set(h3(1), 'YData', y4)
	set(h3(2), 'YData', y4)
	text1 = sprintf('yellow curve: (a, c) = (%6.2f, %6.2f)', a1, c1);
	set(t1, 'string', text1);
	text2 = sprintf('red curve: (a, c) = (%6.2f, %6.2f)', a2, c2);
	set(t2, 'string', text2);
	drawnow
end
