%	Manual tuning of a generalized bell membership funciton.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-4-93.

echo on;
clc;

% This file let you change the a, b and c parameters to see how they affect
% the shape of a generalized bell membership function, which is defined as
% f(x) = 1/{1 + [(x-c)/a]^(2b)}.

echo off;
clg;
set(gcf, 'position', [10 544 560 420]);

x = (-10:0.1:10)';
a = 5; b = 2; c = 0;
y = bell(x, a, b, c);
P = plot(x,y);
axis([min(x) max(x) 0 1]);
title(['a = ' num2str(a) ', b = ' num2str(b) ', c = ' num2str(c)]);
xlabel('Click the sliders to change parameters of this membership function.');

drawnow
hh = gca;

s = ['x=-10:.1:10;' ...
        'a = get(HCa,''Value'');' ...
        'b = get(HCb,''Value'');' ...
        'c = get(HCc,''Value'');' ...
        'y = bell(x, a, b, c);' ...
	'set(P, ''ydata'', y);' ...
	'title([''a = '' num2str(a) '', b = '' num2str(b) '', c = '' num2str(c)]);'];

HCa = uicontrol('Style','slider','Position',[0.95 0.70 0.03 0.20],...
        'Min',1,'Max',10, 'Units', 'normalized', ...
        'Value',5,'CallBack',s);

HCb = uicontrol('Style','slider','Position',[0.95 0.40 0.03 0.20],...
        'Min',0.1,'Max',10, 'Units', 'normalized', ...
        'Value',2,'CallBack',s);

HCc = uicontrol('Style','slider','Position',[0.95 0.10 0.03 0.20],...
        'Min',-10,'Max',10, 'Units', 'normalized', ...
        'Value',0,'CallBack',s);

% an invisible axes for putting on texts
axes('pos',[0 0 1 1],'Visible','off');
% text for a
text(.94,.7,'1','hor','right');
text(.94,.9,'10','hor','right');
text(.94,.8,'a:','horizontalalignment','right');
% text for b
text(.94,.4,'0.1','hor','right');
text(.94,.6,'10','hor','right');
text(.94,.5,'b:','horizontalalignment','right');
% text for c
text(.94,.1,'-10','hor','right');
text(.94,.3,'10','hor','right');
text(.94,.2,'c:','horizontalalignment','right');

set(gcf,'CurrentAxes',hh);
