function y = bell(x, a, b, c)

% BELL	Generalized bell-shaped membership function with
%	three parameters a, b, c.
%	BELL(x, a, b, c) returns a matrix y with the same size
%	as x; each element of y is a grade of membership.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	6-28-93.

[m n] = size(x);
x = x(:);
tmp = ((x - c)/a).^2;
tmp = tmp.^b;
y = ones(m*n,1)./(ones(m*n,1) + tmp);
y = reshape(y,m,n);
