% REASDEMO: To be called from FISDEMO.M.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

clf;set(gcf,'units','normal','position',[.34 .55 .65 .4])

echo on;
clc;
% In this part of demonstration, some commonly used reasoning methods
% will be explained. The name of programs are selected from the related
% contributed papers author's name. Before explaining the reasoning 
% method we have to make a rule-base for our investigation. The rule-base 
% contains 4 rules with 2 antecedent and one consequent. The rules
% are enough for truck backer_upper control system.

U1=[0:2:100];
U2=[-90:10:270];
V=[-30:2:30];

a1=[10 10 10 10]; b1=[1 1 1 1]; c1=[10 -10 50 -50];

a2=[20 20 20 20]; b2=[1 1 1 1]; c2=[90 90 180 -90];

ahat=[5 5 5 5];bhat=[1 1 1 1];chat=[0 0 20 -20];

[A1,A2,B]=rulebase(1,U1,a1,b1,c1,1,U2,a2,b2,c2,1,V,ahat,bhat,chat);

pause % Press any key to continue
clc;
% There are some methods that can handle input fuzzy values Ap, and the
% output also is a fuzzy value Bp. Furthermore some methods use only
% fuzzy singleton Ao as their inputs. To convert the fuzzy value Ap to
% a crisp value Ao and vis versa two functions DEFZFIR and FZFIR can 
% be used. 
% If we want to fuzzify the crisp value 40 (in universe U1),and crisp value
% 90 in the universe U2,  there are different choices.

A1p=fzfir(5,U1,0,0,40);
A2p=fzfir(5,U2,0,0,90);

subplot(121);stem(U1,A1p)
xlabel('Universe of U1');title('Fuzzy singleton A1p');
subplot(122);stem(U2,A2p)
xlabel('Universe of U2');title('Fuzzy value A2p')

pause % Press any key to continue
clf;clc;
% Based on Zadeh's compositional rule of inference and Mamdani's inter-
% pretation for fuzzy implication (Min) the inference procedure is
% presented in the following function. 

[Bp] = zadeh(A1,A1p,A2,A2p,B,1,1);

% The two last parameters specify AND and ALSO operators in production
% rules.

plot(V,Bp)
xlabel('Universe of V');title('Fuzzy conclusion Bp using ZADEH reasoning');


% Note: The output of this algorithm is a fuzzy value.


pause % Press any key to continue 
clc; 
% To defuzzify a fuzzy value Bp over universe of V the following function
% obtain  crisp value related to that fuzzy value.

Bo=defzfir(Bp,V,1)

% The third input parameters of functions specify the defuzzification 
% algorithm.

pause % Press any key to continue
clc;
% When the inputs of inference system are crisp value the decision
% process can be accomplish simply. The procedure has been given as follows;

AND=1; ALSO=1;

[Bp] = mamdani(A1,40,U1,A2,90,U2,B,AND,ALSO);

plot(V,Bp)
xlabel('Universe of V');title('Fuzzy conclusion Bp using MAMDANI reasoning');

Bo=defzfir(Bp,V,1)

pause % Press any key to continue  
clc; 
% Instead using Min-Max algorithm used by Mamdani, The Product-Max
% algorithm introduced by Larsen also can be used.

AND=1; ALSO=1;

[Bp] = larsen(A1,40,U1,A2,90,U2,B,AND,ALSO);

plot(V,Bp)
xlabel('Universe of V');title('Fuzzy conclusion Bp using LARSEN reasoning');

Bo=defzfir(Bp,V,1)


pause % Press any key to continue
clc;
% Based on Sugeno and Takagi's model of inference systems, i.e. crisp
% value on consequent of each rule rather than fuzzy value, the inference
% procedure is give as follows;

AND=1; 

P=[0 0 0
   0 0 0
   0 0 20
   0 0 -20];

[Bo] = sugeno(A1, 40, U1, A2, 90, U2, P, AND)


pause % Press any key to continue
clc;
% In the case inputs as well as output are crisp values, decision process
% can be made simpler by using KOSKO.

AND=1;
MISC=1;

[Bo] = kosko(A1,40,U1,A2,90,U2,B,V,MISC,AND)

pause % Press any key to continue
clc;
% Approximate analogical reasoning based on similarity measure is given 
% in this function. The MISC input vector is a three element that specifys
% similarity, modification and threshold value for reasoning process.

MISC=[1 1 .5];
[Bp] = turksen(A1,A1p,A2,A2p,B,1,MISC);

Bo=defzfir(Bp,V,1)

plot(V,Bp)
xlabel('Universe of V');title('Fuzzy conclusion Bp using TURKSEN reasoning');


pause % Press any key to continue
clc;
% In this part of demonstration the following functions have been explained.
%
%	FZFIR, DEFZFIR
%	ZADEH, MAMDANI, LARSEN, SUGENO, KOSKO, TURKSEN
