function [Bo] = defzfir(dbp,univ,n)

%DEFZFIR In practical reason, the fuzzy control action defined over an
%        output universe should be mapped into a space of
%        deterministic/nonfuzzy/crisp control action. Two most
%        practicable strategies which is used are mean of maximum and
%        the center of gravity.
%
%                     [Bo] = DEFZFIR(Bp,V,N)
%
%        Where Bp is the vector of membership  function of a fuzzy set
%        over universe of discourse V. With selecting variable N
%        1 or 2 respectively center of gravity or mean of maximum
%        strategy  for defuzzification will be selected. The default
%        value for N is 1. The output is a crisp value Bo related to
%        fuzzy set. It is to be noted that the universe V is in
%        ascending order.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

% Checking the inputs of function
if nargin < 3,  n=1;   end

if (max(max(dbp)) > 1) | (min(min(dbp)) < 0)
	error('Grade of membership function should not be more than one or less than zero.')
end

% Using the Mm operator for defuzzification
       if n == 2

mmnon = mean(find(dbp == max(dbp)));
Bo = univ(round(mmnon));

% Using the Mg operator for defuzzification
       else
  non = 0.0 ;fuz = 0.0 ;
  for icon=1:length(univ)
     non = univ(icon)*dbp(icon)+non;
     fuz = dbp(icon)+fuz;
  end
Bo = non/fuz ;

   end
