// -*- C++ -*-

#include "Test.h"
#include "TestTest.h"

#include <iostream.h>


void exit_handler()
{
    cerr << "test: exit_function()" << endl;
}


void test_is_a(const char *name, const CNObject *obj, const CNClass *desc)
{
    if(obj->is_a(desc))
	cout << name << " IS A " << desc->name() << endl;
    else
	cout << name << " IS not A " << desc->name() << endl;
}

    

main()
{
    CNObject *a, *b, *c, *d[2];
    Test *t;
    int i=10;
    
    a = new Test;
    b = CN_TEST->new_object();

    c = new TestTest;
    d[0] = CN_TESTTEST->new_object();
    d[1] = CN_TESTTEST->new_object();
    
    t = Test::cast_from_object(b);
    t = Test::cast_from_object(d[1]);

    a->dump();
    b->dump();
    c->dump();
    d[0]->dump();
    d[1]->dump();
    
//    cout << a << b << c << d[0] << d[1];
    cout << a->class_desc();
    cout << t->class_desc();
    cout << CN_OBJECT << CN_CLASS << CN_PARAM
	 << CN_TEST << CN_TESTTEST;
    
    test_is_a("a", a, CN_OBJECT);
    test_is_a("a", a, CN_CLASS);
    test_is_a("a", a, CN_TEST);
    test_is_a("a", a, CN_TESTTEST);
    
    test_is_a("b", b, CN_OBJECT);
    test_is_a("b", b, CN_CLASS);
    test_is_a("b", b, CN_TEST);
    test_is_a("b", b, CN_TESTTEST);
    
    test_is_a("c", c, CN_OBJECT);
    test_is_a("c", c, CN_CLASS);
    test_is_a("c", c, CN_TEST);
    test_is_a("c", c, CN_TESTTEST);
    
    test_is_a("d[0]", d[0], CN_OBJECT);
    test_is_a("d[0]", d[0], CN_CLASS);
    test_is_a("d[0]", d[0], CN_TEST);
    test_is_a("d[0]", d[0], CN_TESTTEST);
    
    test_is_a("d[1]", d[1], CN_OBJECT);
    test_is_a("d[1]", d[1], CN_CLASS);
    test_is_a("d[1]", d[1], CN_TEST);
    test_is_a("d[1]", d[1], CN_TESTTEST);
    
    test_is_a("t", t, CN_OBJECT);
    test_is_a("t", t, CN_CLASS);
    test_is_a("t", t, CN_TEST);
    test_is_a("t", t, CN_TESTTEST);
    
    // Error handling
    CNCL::set_exit_handler(exit_handler);
    
    CNCL::set_error(CNCL::err_ignore);
    CNCL::error(NIL, "test ignore");
    CNCL::set_error(CNCL::err_warning);
    CNCL::error(NIL, "test warning");
    CNCL::set_error(CNCL::err_fatal);
    CNCL::error(NIL, "test fatal");

    // Additional message
    CNCL::msg() << "Test error() - i=" << i;
    CNCL::error(CNCL::err_info);
    CNCL::msg() << "Test fatal() - i=" << i;
    CNCL::fatal();
    CNCL::msg() << "Test warning() - i=" << i;
    CNCL::warning();
    CNCL::msg() << "Test info() - i=" << i;
    CNCL::info();
    
    // Test err_abort
    CNCL::set_exit_handler(CNCL::default_exit_handler);
    CNCL::set_error(CNCL::err_abort);
    CNCL::error("Expect a core dump");
    
    /*NOT REACHED*/
    return 0;
}

