//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_            C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                      N E T W O R K S
 * |_        |_  |_  |_  |_        |_                            C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                  L I B R A R Y
 *
 * $Id: Statistics.h,v 0.19 1994/01/28 18:54:04 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNStatistics --- Base class for statistical evaluation
 *
 * Derived from SIC - Simulation In C++
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Statistics_h
#define __Statistics_h


#include <CNCL/CNCL.h>
#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>        // Base class

extern CNClassDesc CN_STATISTICS;   // CNClass CNStatistics description


/*
 * The class CNStatistics --- abstract base class for stat. evaluation
 */

class CNStatistics : public CNObject
{
public:
    enum Phase { INITIALIZE=0, ITERATE=1, END=2 };
    enum Type  { DF=0, CDF=1 };

    virtual void          put(double val)   = 0; // Input value
    virtual double        mean()      const = 0; // Return mean value
    virtual double        variance()  const = 0; // Return variance
    virtual unsigned long trials()    const = 0; // Return number of trials
    virtual double    	  min()       const = 0; // maximal value of trials
    virtual double    	  max()       const = 0; // minimal     - " -
    virtual void          reset()           = 0; // Reset evaluation
    virtual bool          end()       const = 0; // end of evaluation 
                                                 // reached ?
    virtual Phase         status()    const = 0; // Return state 
                                                 // of evaluation

    /***** Constructors ******************************************************/
public:
    CNStatistics() {}               // Default constructor
    CNStatistics(CNParam *param) {}         // CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const  // CNClass description
    {
    return CN_STATISTICS;
    };
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
    return desc == CN_STATISTICS ? TRUE : CNObject::is_a(desc);
    };
        
    static CNStatistics *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
    return (CNStatistics *)obj;
#   else
    return (CNStatistics *)( obj->is_a(CN_STATISTICS)
           ? obj : fatal_type(obj->class_desc(), CN_STATISTICS) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__Statistics_h**/
