//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: LREF.h,v 0.19 1994/01/28 18:54:04 cncl-adm Exp cncl-adm $
 *
 * Class: CNLREF --- LRE evaluation F(x) (distribution function)
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __LREF_h
#define __LREF_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/LRE.h>           // Base class

extern CNClassDesc CN_LREF;     // CNClass CNLREF description


/*
 * The class CNLREF
 */

class CNLREF : public CNLRE
{
  public:
    virtual void put(double);
    // Private members
  private:
    void      neusort(struct result*);
    void      quicksort(struct sm*, struct sm*);
    struct sm *mergesort(struct sm*);
    void      verbesser(struct result*, struct result*, double, double);
    double    end_lev() {return -MAXDOUBLE;};

    /***** Constructors ******************************************************/
public:
    CNLREF(double MIN=0.01, double MAX=0.99, double MAX_ERR=0.05, 
           int LEVEL=100, Scale SCALE=CNLRE::LIN, int MAXSORT = 0, 
           char* NAME = "no name", char* TEXT = "no text")
        : CNLRE (MIN,MAX,MAX_ERR,LEVEL,SCALE,MAXSORT,NAME,TEXT)
    {
        rvakt       = -MAXDOUBLE;
        pr->xlevlim = MAXDOUBLE;
    };
    CNLREF(CNParam *param) {}                   // CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const      // CNClass description
    {
        return CN_LREF;
    };
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
        return desc == CN_LREF ? TRUE : CNLRE::is_a(desc);
    };
        
    static CNLREF *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNLREF *)obj;
#   else
        return (CNLREF *)( obj->is_a(CN_LREF)
               ? obj : fatal_type(obj->class_desc(), CN_LREF) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNLREF(param) : new CNLREF; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const
        { CNLRE::print( CNStatistics::DF, strm ); }
//    virtual void dump (ostream &strm = cout) const;
};


#endif /**__LREF_h**/
