//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SSMP2.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * Class: CNSSMP2 --- Semi-Markov-Process
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNSSMP2_h
#define __CNSSMP2_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Uniform.h>
#include <CNCL/ArrayDouble.h>
#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_SSMP2;	// Class CNSSMP2 description


/*
 * The class CNSSMP2
 */

class CNSSMP2 : public CNRandom
{

public:

     double get_correlation();
     CNArrayDouble get_stat_prob();
     virtual double operator()();

private:

     double p;		     // stat. state probability p = P1
     CNArrayDouble statProb; // stat. state probability vector
     double p10;	     // transition probability p10 = P(0|1)
     double p01;	     // transition probability p01 = P(1|0)
     double rho;	     // correlation

     double kappa;	     // probability for next state "1"
     double time;	     // generated time
     double randi;	     // uniform distributed number

     CNUniform *generator_uniform;              // uniform generator 0....1
     CNRandom *generator_distribution_state_0;	// generator state "0"
     CNRandom *generator_distribution_state_1;	// generator state "1"


    /***** Constructors ******************************************************/
public:
    CNSSMP2() : CNRandom(NIL) {}	   	// Default constructor
    CNSSMP2(CNParam *param) : CNRandom(NIL) {}	// CNParam constructor

    CNSSMP2(double cp01, double cp10,
	    CNRandom *cgenerator_distribution_state_0,
	    CNRandom *cgenerator_distribution_state_1, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SSMP2;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SSMP2 ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNSSMP2 *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSSMP2 *)obj;
#   else
	return (CNSSMP2 *)( !obj || obj->is_a(CN_SSMP2)
	       ? obj : fatal_type(obj->class_desc(), CN_SSMP2) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSSMP2(param) : new CNSSMP2; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNSSMP2_h**/
