//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Rice.c,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNRice --- CNRice distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "Rice.h"



double CNRice::operator()()
{
	double a = this->CNNormal::operator()();
	double c = this->CNNormal::mean(0); 
	double b = this->CNNormal::operator()();
	this->CNNormal::mean(c);
	return sqrt( a*a + b*b );
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNRice::print(ostream &strm) const
{
    strm << "CNNormal mean=0/" << pMean << " var=" << pVariance << endl;
}

// Debug output
void CNRice::dump(ostream &strm) const
{
    strm << "CNRice { "
	 << "CNNormal mean=0/" << pMean << " var=" << pVariance
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNRice
static CNClass CNRice_desc("CNRice", "$Revision: 0.19 $", CNRice::new_object);

// "Type" for type checking functions
CNClassDesc CN_RICE = &CNRice_desc;






