//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Erlang.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNErlang --- CNErlang-k distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __Erlang_h
#define __Erlang_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_ERLANG;	// CNClass CNErlang description


/*
 * The class CNErlang
 */

class CNErlang : public CNRandom
{
protected:
    double pMean;
    double pVariance;
    int k;
    double a;
    void setState();

public:
    double mean();
    double mean(double x);
    double variance();
    double variance(double x);

    virtual double operator()() ;

    /***** Constructors ******************************************************/
public:
    CNErlang();        				// Default constructor
    CNErlang(CNParam *param); 			// CNParam constructor
    CNErlang(double mean, double variance, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_ERLANG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_ERLANG ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNErlang *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNErlang *)obj;
#   else
	return (CNErlang *)( !obj || obj->is_a(CN_ERLANG)
	       ? obj : fatal_type(obj->class_desc(), CN_ERLANG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNErlang(param) : new CNErlang; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const ;
    virtual void dump (ostream &strm = cout) const ;
};


inline void CNErlang::setState()
{
    k = int( (pMean * pMean ) / pVariance + 0.5 );
    k = (k > 0) ? k : 1;
    a = k / pMean;
}

inline CNErlang::CNErlang(double mean, double variance, CNRNG *gen) : CNRandom(gen)
{
    pMean = mean; pVariance = variance;
    assert( ( pMean > 0 ) && ( pVariance > 0) ); // this line added
    setState();
}

inline CNErlang::CNErlang() 
	 : CNRandom((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    a = 0; 
    k = 0;
    
}

inline CNErlang::CNErlang(CNParam *param) 
	  : CNRandom ((CNRNG*)NIL)
{
    pMean = 0;
    pVariance = 0;
    a = 0;
    k = 0;
}    
    
inline double CNErlang::mean() { return pMean; }
inline double CNErlang::mean(double x) {
  double tmp = pMean; 
  pMean = x; 
  setState(); 
  return tmp;
};

inline double CNErlang::variance() { return pVariance; }
inline double CNErlang::variance(double x) {
  double tmp = pVariance; 
  pVariance = x; 
  setState(); 
  return tmp;
}

#endif /**__Erlang_h**/



