//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DiracTab.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDiracTab --- Created from CNCL template
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __DiracTab_h
#define __DiracTab_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_DIRACTAB;	// CNClass CNDiracTab description



struct CNDiracTabEntry
{ 
    double xval;
    double yval;
};


/*
 * The class CNDiracTab
 */

class CNDiracTab : public CNRandom
{
protected: 
    CNDiracTabEntry *adr;
    long len;

public:
    virtual double operator()() ;

    /***** Constructors ******************************************************/
public:
    CNDiracTab();   				// Default constructor
    CNDiracTab(CNParam *param); 			// CNParam constructor
    CNDiracTab(CNDiracTabEntry *address, long length, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DIRACTAB;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DIRACTAB ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNDiracTab *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDiracTab *)obj;
#   else
	return (CNDiracTab *)( !obj || obj->is_a(CN_DIRACTAB)
	       ? obj : fatal_type(obj->class_desc(), CN_DIRACTAB) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDiracTab(param) : new CNDiracTab; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


inline CNDiracTab::CNDiracTab(CNDiracTabEntry *address, long length, CNRNG *gen)
    : CNRandom(gen)
{
    adr  =address;
    len  =length;
}



inline CNDiracTab::CNDiracTab() : CNRandom ((CNRNG*)NIL)
{
    adr = 0;
    len = 0;
}

inline CNDiracTab::CNDiracTab(CNParam *param) : CNRandom((CNRNG*)NIL)
{
    adr = 0;
    len = 0;
}

#endif /**__DiracTab_h**/
