//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FormInt.c,v 0.19 1994/01/28 18:55:13 cncl-adm Exp cncl-adm $
 *
 * Class: CNFormInt --- Integer as CNStrings
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "FormInt.h"

#include <strstream.h>


 /*
  *  Creates the String out of the given parameters 
  */

void CNFormInt::initialize( int a, int w, char fill, int f)
{
    delete p;
    init(w);
    val  = a;
    wide  = w;
    cfill  = fill;
    form = f;
    ostrstream o(p, w+1);
    o.width(w);
    if (f == left)
	o.setf(ios::left);
    o.fill(fill);
    o << a << ends;
}




 /*
  * Changes the String and sets the value to a
  */
void CNFormInt::set_value(int a)
{
    if (val != a) initialize( a, wide, cfill, form);
}

void CNFormInt::value(int a)
{
    if (val != a) initialize( a, wide, cfill, form);
}

 /*
  *  Changes the String and sets the fill parameter to f 
  */
void CNFormInt::set_fill(char f)
{
    if (cfill != f) initialize( val, wide, f, form);
}

void CNFormInt::fill(char f)
{
    if (cfill != f) initialize( val, wide, f, form);
}

 /*
  *  Changes the String and sets the format parameter to f
  */
void CNFormInt::set_format(int f)
{
    if (form != f) initialize( val, wide, cfill, f);
}
 
void CNFormInt::format(int f)
{
    if (form != f) initialize( val, wide, cfill, f);
}

 /*
  *  Changes the String and sets the width to w
  */ 
void CNFormInt::set_width(int w)
{
    if (wide != w) initialize( val, w, cfill, form);
}

void CNFormInt::width(int w)
{
    if (wide != w) initialize( val, w, cfill, form);
}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNFormInt::print(ostream &strm) const
{
    strm << p << endl;
}

// Debug output
void CNFormInt::dump(ostream &strm) const
{
    strm << "CNFormInt { $Revision: 0.19 $ " << p 
	 << " width: " << wide
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNFormInt
static CNClass CNFormInt_desc("CNFormInt", "$Revision: 0.19 $",
			    CNFormInt::new_object);

// "Type" for type checking functions
CNClassDesc CN_FORMINT = &CNFormInt_desc;
