//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSetTriangle.c,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSetTriangle --- Fuzzy set mit triangle function
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "FSetTriangle.h"



/*
 * Contructors
 */
CNFSetTriangle::CNFSetTriangle()
    : CNFSetTrapez(0, 0, 0, 0, 0, 0)
{}


CNFSetTriangle::CNFSetTriangle(CNParam *param)
    : CNFSetTrapez(0, 0, 0, 0, 0, 0)
{}


CNFSetTriangle::CNFSetTriangle(double min, double max, double xm,
			       double xalpha, double xbeta )
    : CNFSetTrapez(min, max, xm, xm, xalpha, xbeta)
{}


CNFSetTriangle::CNFSetTriangle(double xm,
			       double xalpha, double xbeta )
    : CNFSetTrapez(xm, xm, xalpha, xbeta)
{}


CNFSetTriangle::CNFSetTriangle(const CNString &xname,
			       double min, double max, double xm,
			       double xalpha, double xbeta )
    : CNFSetTrapez(xname, min, max, xm, xm, xalpha, xbeta)
{}


CNFSetTriangle::CNFSetTriangle(const CNString &xname, double xm,
			       double xalpha, double xbeta )
    : CNFSetTrapez(xname, xm, xm, xalpha, xbeta)
{}



/*
 * Compute membership value for x - optimized version for triangle
 */
double CNFSetTriangle::get_membership(double x) const
{
    double dy = ymax - ymin;

    // Triangle: m1 == m2 !
    if(x<=(m1-alpha) || x>=(m2+beta))
	return ymin;
    if(x < m1)
	return ymin + dy*(x-(m1-alpha))/alpha;
    return ymin + dy*(m2+beta-x)/beta; 
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNFSetTriangle::print(ostream &strm) const
{
    strm << "SET TRIANGLE " << name()
	 << "(" << m1 << ", " << alpha << ", " << beta << ")";
}

// Debug output
void CNFSetTriangle::dump(ostream &strm) const
{
    strm << "CNFSetTriangle { $Revision: 0.19 $" << endl;
    print(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNFSetTriangle
static CNClass CNFSetTriangle_desc("CNFSetTriangle", "$Revision: 0.19 $",
				   CNFSetTriangle::new_object);

// "Type" for type checking functions
CNClassDesc CN_FSETTRIANGLE = &CNFSetTriangle_desc;






