//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSetTrapez.h,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSetTrapez --- Fuzzy set with trapezium function
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFSetTrapez_h
#define __CNFSetTrapez_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/FSetLR.h>		// Base class

extern CNClassDesc CN_FSETTRAPEZ;	// CNClass CNFSetTrapez description


/*
 * The class CNFSetTrapez
 */

class CNFSetTrapez : public CNFSetLR
{
  public:
					// Get membership values for x
    					// Optimized version for trapezium
    virtual double get_membership(double x) const;

    /***** Constructors ******************************************************/
  public:
    CNFSetTrapez();			// Default constructor
    CNFSetTrapez(CNParam *param);	// CNParam constructor
    CNFSetTrapez(double min, double max, 
		 double xm1, double xm2, double xalpha, double xbeta );
    CNFSetTrapez(double xm1, double xm2, double xalpha, double xbeta );
    CNFSetTrapez(const CNString &xname, double min, double max, 
		 double xm1, double xm2, double xalpha, double xbeta );
    CNFSetTrapez(const CNString &xname,
		 double xm1, double xm2, double xalpha, double xbeta );

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FSETTRAPEZ;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FSETTRAPEZ ? TRUE : CNFSetLR::is_a(desc);
    };
        
    static CNFSetTrapez *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFSetTrapez *)obj;
#   else
	return (CNFSetTrapez *)( !obj || obj->is_a(CN_FSETTRAPEZ)
	       ? obj : fatal_type(obj->class_desc(), CN_FSETTRAPEZ) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFSetTrapez(param) : new CNFSetTrapez; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFSetTrapez_h**/
