//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSetLR.h,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSetLR --- Fuzzy set with L and R functions
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFSetLR_h
#define __CNFSetLR_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/FSet.h>		// Base class

extern CNClassDesc CN_FSETLR;	// CNClass CNFSetLR description



/*
 * Functions
 */
double CNFuncExp (double x);		// exp(-x)
double CNFuncExp2(double x);		// exp(-x^2)
double CNFuncLin (double x);		// 1-x
double CNFuncSqr (double x);		// 1-x^2
double CNFuncHyp (double x);		// 1/(1+x)
double CNFuncHyp2(double x);		// 1/(1+x^2)

typedef double (*CNFuncType)(double x);	// Function pointer



/*
 * The class CNFSetLR
 */

class CNFSetLR : public CNFSet
{
  public:
					// Get membership values for x
    virtual double get_membership(double x) const;
	
  protected:

    CNFuncType L, R;			// L, R functions
    double m1, m2, alpha, beta;		// Parameters

    /***** Constructors ******************************************************/
  public:
    CNFSetLR();				// Default constructor
    CNFSetLR(CNParam *param);		// CNParam constructor
    CNFSetLR(double min, double max, 
	     double xm1, double xm2, double xalpha, double xbeta,
	     CNFuncType fL, CNFuncType fR                            );
    CNFSetLR(double xm1, double xm2, double xalpha, double xbeta,
	     CNFuncType fL, CNFuncType fR                            );
    CNFSetLR(const CNString &xname, double min, double max, 
	     double xm1, double xm2, double xalpha, double xbeta,
	     CNFuncType fL, CNFuncType fR                            );
    CNFSetLR(const CNString &xname,
	     double xm1, double xm2, double xalpha, double xbeta,
	     CNFuncType fL, CNFuncType fR                            );
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FSETLR;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FSETLR ? TRUE : CNFSet::is_a(desc);
    };
        
    static CNFSetLR *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFSetLR *)obj;
#   else
	return (CNFSetLR *)( !obj || obj->is_a(CN_FSETLR)
	       ? obj : fatal_type(obj->class_desc(), CN_FSETLR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFSetLR(param) : new CNFSetLR; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFSetLR_h**/
