//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSet.h,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSet --- Fuzzy set abstract base class
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFSet_h
#define __CNFSet_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Named.h>		// Base class

extern CNClassDesc CN_FSET;	// CNClass CNFSet description


/*
 * The class CNFSet
 */

class CNFSet : public CNNamed
{
  public:
					// Get membership values for x
    virtual double get_membership(double x) const = 0;
					// Compute center of gravity
    virtual double center_of_gravity(double min, double max) const;

  protected:
    double ymin, ymax;			// Range of membership values

  private:

    /***** Constructors ******************************************************/
  public:
    CNFSet(CNParam *param);		// CNParam constructor
    CNFSet(double min=0, double max=1);
    CNFSet(const CNString &xname, double min=0, double max=1);

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FSET;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FSET ? TRUE : CNObject::is_a(desc);
    };
        
    static CNFSet *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFSet *)obj;
#   else
	return (CNFSet *)( !obj || obj->is_a(CN_FSET)
	       ? obj : fatal_type(obj->class_desc(), CN_FSET) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__CNFSet_h**/
