//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSet.c,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSet --- Fuzzy set abstract base class
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "FSet.h"



/*
 * Constructors
 */
CNFSet::CNFSet(CNParam *param)
    : CNNamed(""), ymin(0), ymax(0)
{}


CNFSet::CNFSet(double min, double max)
    : CNNamed(""), ymin(min), ymax(max)
{}


CNFSet::CNFSet(const CNString &xname, double min, double max)
    : CNNamed(xname), ymin(min), ymax(max)
{}



/*
 * Compute center of gravity for defuzzyfication
 */
double CNFSet::center_of_gravity(double min, double max) const
{
    error(NIL, "CNFSet::center_of_gravity(): not yet implemented");
    return 0;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNFSet
static CNClass CNFSet_desc("CNFSet", "$Revision: 0.19 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_FSET = &CNFSet_desc;



