//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FRule.c,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFRule --- Fuzzy rule
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER*******************************************************************/

#include <values.h>

#include <CNCL/ArrayDouble.h>

#include "FRule.h"



/*
 * Add clause to LHS
 */
void CNFRule::add_lhs(CNFClause *clause)
{
    int n = lhs.get_size();
    
    lhs.set_size(n + 1);
    lhs[n] = clause;
}

void CNFRule::add_lhs(CNFClause &clause)
{
    add_lhs(&clause);
}



/*
 * Add clause to RHS
 */
void CNFRule::add_rhs(CNFClause *clause)
{
    int n = rhs.get_size();
    
    rhs.set_size(n + 1);
    rhs[n] = clause;
}

void CNFRule::add_rhs(CNFClause &clause)
{
    add_rhs(&clause);
}



/*
 * Get/set certainty
 */
double CNFRule::set_certainty(double x)
{
    double old = r_certainty;
    r_certainty = x;
    return old;
}

double CNFRule::certainty(double x)
{
    double old = r_certainty;
    r_certainty = x;
    return old;
}


double CNFRule::get_certainty() const
{
    return r_certainty;
}

double CNFRule::certainty() const
{
    return r_certainty;
}



/*
 * Get # of clauses
 */
int CNFRule::get_n_lhs() const
{
    return lhs.get_size();
}

int CNFRule::get_n_rhs() const
{
    return rhs.get_size();
}



/*
 * Get clause from LHS
 */
CNFClause *CNFRule::get_lhs(int i) const
{
    return CNFClause::cast_from_object( lhs.get(i) );
}



/*
 * Get clause from RHS
 */
CNFClause *CNFRule::get_rhs(int i) const
{
    return CNFClause::cast_from_object( rhs.get(i) );
}



/*
 * Aggregate LHS of rule
 */
double CNFRule::aggregate(/**Operator!**/)
{
    int i;
    int n = get_n_lhs();
    CNArrayDouble a(n);
    CNFVar *v;
    CNFSet *s;
    
    for(i=0; i<n; i++)
    {
	v = CNFClause::cast_from_object( lhs[i] )->var;
	s = CNFClause::cast_from_object( lhs[i] )->value;
	
	a[i] = s->get_membership( v->value() );
    }
    
    /**FIXME: Use operator instead of min()**/
    double min = MAXDOUBLE;
    for(i=0; i<n; i++)
	if(a[i] < min)
	    min = a[i];
    
    agg_value = min * certainty();
    return agg_value;
}



/*
 * Get result of aggregate()
 */
double CNFRule::aggregate_value() const
{
    return agg_value;
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNFRule::print(ostream &strm) const
{
    int i, l, r;
	
    l = get_n_lhs();
    r = get_n_rhs();
	
    strm << "IF" << endl;
    for(i=0; i<l; i++)
	if(i == 0)
	    strm << "        " << lhs.get(i) << endl;
	else
	    strm << "    AND " << lhs.get(i) << endl;
    strm << "THEN" << endl;
    for(i=0; i<r; i++)
	if(i == 0)
	    strm << "        " << rhs.get(i) << endl;
	else
	    strm << "    AND " << rhs.get(i) << endl;
    strm << "WITH CERTAINTY " << certainty() << ";" << endl;
}

// Debug output
void CNFRule::dump(ostream &strm) const
{
    strm << "CNFRule { $Revision: 0.19 $" << endl
	 << "certainty=" << r_certainty << endl
	 << "lhs=" << endl;
    lhs.dump(strm);
    strm << "rhs=" << endl;
    rhs.dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNFRule
static CNClass CNFRule_desc("CNFRule", "$Revision: 0.19 $",
			    CNFRule::new_object);

// "Type" for type checking functions
CNClassDesc CN_FRULE = &CNFRule_desc;






