// -*- C++ -*-

#include <unistd.h>

#include <CNCL/String.h>

#include <CNCL/EZD.h>
#include <CNCL/EZDWindow.h>
#include <CNCL/EZDDrawing.h>
#include <CNCL/EZDObject.h>
#include <CNCL/EZDQueue.h>
#include <CNCL/EZDServer.h>


int main()
{
    EZDWindow win(400, 400);
    EZDDrawing draw;
    
    win.overlay(&draw);

    EZD::draw_point(0,0,"");
    EZD::draw_point(1,1,"");
    EZD::draw_point(2,2,"");
    EZD::draw_point(3,3,"");

    EZD::draw_line(100,100,300,300,"");
    EZD::draw_line(120,100,320,300, "Red", 2);
    EZD::draw_line(140,100,340,300,"",4);

    EZD::draw_rectangle(50,350,300,50,"");
    EZD::draw_rectangle(40,340,300,50, "Blue", 3);
    
    EZD::draw_fill_rectangle(50,150,300,50, "Green");

    EZDObject obj;
    for(int i=0; i<100; i++)
    {
	obj.x(i*4);
	obj.y(i*4);
	obj.start();
	obj.line( 0, 0,40, 0,"");
	obj.line( 0,40,40,40,"");
	obj.line( 0, 0, 0,40,"");
	obj.line(40, 0,40,40,"");
	obj.line( 0, 0,40,40,"");
	obj.line( 0,40,40, 0,"");
	obj.end();
	usleep(100000);
    }

    EZDQueue q(100, 100);
    EZDServer s(q.right(), 100);
    q.redraw();
    s.redraw();
    s.color("Green");
    
    CNString in; cin >> in;
    q.length(50);
    s.color("Red");
    
    cin >> in;
    q.length(100);
    
    cin >> in;

}


