//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDTimer.h,v 0.19 1994/01/28 18:55:41 cncl-adm Exp cncl-adm $
 *
 * Class: EZDTimer --- Graphical representation of Timer
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDTimer_h
#define __EZDTimer_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZDObject.h>		// Base class

extern CNClassDesc CN_EZDTIMER;	// Class EZDTimer description


/*
 * The class EZDTimer
 */

class EZDTimer : public EZDObject
{
public:
    // Return layout coordinates
    int left()   const { return x()-rx; }
    int right()  const { return x()+rx; }
    int upper()  const { return y()-ry; }
    int lower()  const { return y()+ry; }

    // Redraw Timer
    virtual void redraw();

    // Set/draw pie
    int angle()            const { return a2; }
    void angle(int a);
    int get_angle()        const { return a2; }
    void set_angle(int a);
  int offset_angle()     const { return a1; }
  void offset_angle(int a);
  int get_offset_angle() const { return a1; }
  void set_offset_angle(int a);

    void color(const CNString &c) { col = c; redraw_pie(); }

  void activate();
  void deactivate();
  void active_color(const CNString &c) { active_col = c; }
    
    // Private members
private:
    // Layout parameters
    enum { RADIUSX=5, RADIUSY=5, SEP=1, ACT_SEP=4 };

    /*
     *    x1   x     
     *         -        y1
     *      /  |a1\
     *         |    
     *     |---+---|    y
     *        /|
     *      \a2|  /          a1: offset to begin timer
     *         -             a2: pie dimension
     */

    int x1, y1, rx, ry, w, h, a1, a2;
    EZDObject *pie;
    CNString col, active_col;
    
    void initialize(int radiusx, int radiusy);
    void redraw_pie();
    
    /***** Constructors ******************************************************/
public:
    EZDTimer()
	: EZDObject("Timer", 0, 0) { initialize(RADIUSX, RADIUSY); }
    EZDTimer(CNParam *param)
	: EZDObject("Timer", 0, 0) { initialize(RADIUSX, RADIUSY); }
    EZDTimer(int x, int y,
	     int radiusx=RADIUSX, int radiusy=RADIUSY)
	: EZDObject("Timer", x, y) { initialize(radiusx, radiusy); }
    EZDTimer(const CNString &name, int x, int y,
	     int radiusx=RADIUSX, int radiusy=RADIUSY)
	: EZDObject(name, x, y)    { initialize(radiusx, radiusy); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDTIMER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDTIMER ? TRUE : EZDObject::is_a(desc);
    };
        
    static EZDTimer *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDTimer *)obj;
#   else
	return (EZDTimer *)( !obj || obj->is_a(CN_EZDTIMER)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDTIMER) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDTimer(param) : new EZDTimer; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDTimer_h**/
