//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDText.c,v 0.19 1994/01/28 18:55:41 cncl-adm Exp cncl-adm $
 *
 * Class: EZDText --- ezd object with text
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "EZDText.h"

#include <strstream.h>



/*
 * Draw text object
 */
void EZDText::redraw()
{
    start();
    text(0, 0, txt, "", fnt);
    end();
    EZD::pause(1);
}



/*
 * Create text from text/integer/double
 */
void EZDText::set_text_val(int x)
{
    char buffer[128];
    memset(buffer, 0, 128);
    ostrstream strm(buffer, 128);
    
    strm << x;
    set_text(buffer);
}


void EZDText::set_text_val(const CNString &t, int x)
{
    char buffer[128];
    memset(buffer, 0, 128);
    ostrstream strm(buffer, 128);
    
    strm << t << " " << x;
    set_text(buffer);
}


void EZDText::set_text_val(double x)
{
    char buffer[128];
    memset(buffer, 0, 128);
    ostrstream strm(buffer, 128);
    
    strm << x;
    set_text(buffer);
}


void EZDText::set_text_val(const CNString &t, double x)
{
    char buffer[128];
    memset(buffer, 0, 128);
    ostrstream strm(buffer, 128);
    
    strm << t << " " << x;
    set_text(buffer);
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDText::print(ostream &strm) const
{
    strm << name() << ": x=" << x() << " y=" << y() << endl;
    strm << " text=" << txt << endl;
}

// Debug output
void EZDText::dump(ostream &strm) const
{
    strm << "EZDText { $Revision: 0.19 $" << endl;
    strm << name() << ": x=" << x() << " y=" << y() << endl;
    strm << " text=" << txt << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDText
static CNClass EZDText_desc("EZDText", "$Revision: 0.19 $",
			  EZDText::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDTEXT = &EZDText_desc;






