//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: EZDPopUp --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __EZDPopUp_h
#define __EZDPopUp_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/EZDObject.h>	// Base class
extern CNClassDesc CN_EZDPOPUP;	// Class EZDPopUp description


typedef struct menue
{
    int posx, posy;
    int height;
    CNString title;
    CNString t_color;
    CNString b_color, f_color;
    CNString *inhalt;
    CNString *scheme_func;
    int anz;
}
MENU;
    


/*
 * The class EZDPopUp
 */

class EZDPopUp : public EZDObject
{
  public:
  

    // Private members
  private:


    /***** Constructors ******************************************************/
  public:
    EZDPopUp() {}				// Default constructor
    EZDPopUp(CNParam *param) {}			// CNParam constructor
    EZDPopUp(const int nmenu, const MENU *menu ...);
    

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDPOPUP;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDPOPUP ? TRUE : EZDObject::is_a(desc);
    };
        
    static EZDPopUp *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDPopUp *)obj;
#   else
	return (EZDPopUp *)( !obj || obj->is_a(CN_EZDPOPUP)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDPOPUP) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDPopUp(param) : new EZDPopUp; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDPopUp_h**/
