//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDObject.h,v 0.19 1994/01/28 18:55:41 cncl-adm Exp cncl-adm $
 *
 * Class: EZDObject --- Interface to ezd object
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDObject_h
#define __EZDObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/EZD.h>		// Base class

extern CNClassDesc CN_EZDOBJECT;	// Class EZDObject description


/*
 * The class EZDObject
 */

class EZDObject : public EZD
{
public:
    // Start/end object drawing commands
    void start();
    void start(const CNString &object_name);
    void end();
    void delete_obj(const CNString &draw_name = "draw");
    int get_lastxb(void) { return(lastxb); }
    int get_lastyb(void) { return(lastyb); }
    int get_lastxe(void) { return(lastxe); }
    int get_lastye(void) { return(lastye); }

    // Coordinates
    int x()       const { return ox; }
    int x(int vx)       { int old=ox; ox=vx; return old; }
    int y()       const { return oy; }
    int y(int vy)       { int old=oy; oy=vy; return old; }
    
    // Drawing commands
    void point(int x, int y, const CNString &col);
    void line(int x1, int y1, int x2, int y2,
	      const CNString &col, int width=-1);
    void arc(int x, int y, int w, int h, int a1, int a2,
	      const CNString &col, int width=-1);
    void fill_arc(int x, int y, int w, int h, int a1, int a2,
		   const CNString &col);
    void pie_arc(int x, int y, int w, int h, int a1, int a2,
		   const CNString &col);
    void rectangle(int x, int y, int w, int h,
		   const CNString &col, int width=-1);
    void fill_rectangle(int x, int y, int w, int h, const CNString &col);
    void text(int x, int y, const CNString &text,
	      const CNString &col, const CNString &font);
    void text(int x, int y, int w, int h, const CNString align,
	      const CNString &text, const CNString &col,
	      const CNString &font);
    void bitmap(int x, int y, int w, int h, const CNString &filename,
		const CNString &color1 = "black",
		const CNString &color2 = "");
    void bitmap(int x, int y, const CNString &filename,
		const CNString &color1 = "black",
		const CNString &color2 = "");
    

    // Virtual redraw function to be implemented by derived objects
    virtual void redraw();

    // Private members
private:
    int ox, oy;				// Object's x/y position
    int lastxb, lastyb;             // Last Object Position for moving objects
    int lastxe, lastye;
    

    /***** Constructors ******************************************************/
public:
    EZDObject()
	: EZD("obj"), ox(0), oy(0)                {}
    EZDObject(CNParam *param)
	: EZD("obj"), ox(0), oy(0)                {}
    EZDObject(int x, int y)
	: EZD("obj"), ox(x), oy(y)                {}
    EZDObject(const CNString &name, int x, int y)
	: EZD(name),  ox(x), oy(y), lastxb(0), lastyb(0), lastxe(0),
          lastye(0) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDOBJECT;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDOBJECT ? TRUE : EZD::is_a(desc);
    };
        
    static EZDObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDObject *)obj;
#   else
	return (EZDObject *)( !obj || obj->is_a(CN_EZDOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDObject(param) : new EZDObject; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDObject_h**/
