//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SimTime.h,v 0.19 1994/01/28 18:55:23 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNSimTime --- Simulation time
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __SimTime_h
#define __SimTime_h

#if 1
/*
 * Due to less efficieny of the class CNSimTime, simulation time is
 * typedef'd as a simple double.
 */
typedef double CNSimTime;

#define NO_CNSIMTIME

#else /***********************************************************************/

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_SIMTIME;	// CNClass CNSimTime description


/*
 * The class CNSimTime
 */

class CNSimTime : public CNObject
{
public:
    double time() const
    {
	return simtime;
    }

    double get_time() const
    {
	return simtime;
    }

    double time(double t)
    {
	double val = simtime;
	simtime = t;
	return val;
    }

    double set_time(double t)
    {
	double val = simtime;
	simtime = t;
	return val;
    }

    operator double () const
    {
	return simtime;
    }

    double operator = (double t)
    {
	return simtime = t;
    }
    
    double inc_time(double t)
    {
	return simtime += t;
    }
    
    double operator += (double t)
    {
	return simtime += t;
    }
    
    // Private members
private:
    double simtime;			// The simulation time

    /***** Constructors ******************************************************/
public:
    CNSimTime()                 : simtime(0) {}
    CNSimTime(CNParam *param)     : simtime(0) {}
    CNSimTime(const CNSimTime &t) : simtime(t) {}
    CNSimTime(double t)         : simtime(t) {}
    
    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SIMTIME;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SIMTIME ? TRUE : CNObject::is_a(desc);
    };
        
    static CNSimTime *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSimTime *)obj;
#   else
	return (CNSimTime *)( !obj || obj->is_a(CN_SIMTIME)
	       ? obj : fatal_type(obj->class_desc(), CN_SIMTIME) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSimTime(param) : new CNSimTime; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**********************************************************************/

#endif /**__SimTime_h**/
