// -*- C++ -*-

#include <iostream.h>

#include <CNCL/DLList.h>
#include <CNCL/DLIterator.h>

#include "Test.h"



int main()
{
    CNDLList list;
    
    list.append(new Test(111));
    list.append(new Test(222));
    list.append(new Test(333));
    list.append(new Test(444));
    list.append(new Test(555));
    list.append(new Test(666));
    list.append(new Test(777));
    list.append(new Test(888));
    list.append(new Test(999));

//    cout << list;

    CNDLIterator trav(list);
    CNObject *p;

    // Output original list
    cout << "----------" << endl;
    while(p = trav++)
	cout << p;

    // Add items before and after each second element
    for(trav.reset(list); p=trav.object();)
    {
	CNDLObject *pos;
	pos = trav.position();
	trav++;
	trav++;
	list.insert_before(pos, new Test(0));
	list.insert_after (pos, new Test(1));
    }
    
    cout << "----------" << endl;
    for(trav.reset(list); p=trav.object(); trav++)
    {
	cout << p;
    }

    // Delete all items with n == 0
    for(trav.reset(list); p=trav.object(); )
    {
	Test *t;
	CNDLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 0)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    cout << "----------" << endl;
    for(trav.reset(list); p=trav.object(); trav++)
    {
	cout << p;
    }

    // Delete all items with n == 1
    for(trav.reset(list); p=trav.object(); )
    {
	Test *t;
	CNDLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 1)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    // Reverse output
    cout << "----------" << endl;
    for(trav.first(); p=trav.object(); trav++)
    {
	cout << p;
    }

    // Reverse output
    cout << "----------" << endl;
    for(trav.last(); p=trav.object(); trav--)
    {
	cout << p;
    }

    // Delete all items
    list.delete_all();
    cout << "----------" << endl;
    for(trav.reset(list); p=trav.object(); trav++)
    {
	cout << p;
    }
    
    list.ok();
//    list.dump();
}
