//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: QueueFIFO.h,v 0.19 1994/01/28 18:54:15 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNQueueFIFO --- FIFO queue, n_w = \infty (almost)
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __QueueFIFO_h
#define __QueueFIFO_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Queue.h>		// Base class

#include <CNCL/DLList.h>

extern CNClassDesc CN_QUEUEFIFO;	// CNClass CNQueueFIFO description



/*
 * The class CNQueueFIFO
 */

class CNQueueFIFO : public CNQueue
{
  public:
    virtual bool empty()  const;	// Is queue empty?
    virtual bool full()   const;	// Is queue full?
    virtual int  length() const;	// Length of queue
    virtual void put(CNObject *obj);	// Put object into queue
    virtual CNObject *get();		// Get object from queue
    virtual void delete_all();		// Delete all objects in queue

    // Private members
  private:
    int n;
    CNDLList list;
    
    /***** Constructors ******************************************************/
  public:
    CNQueueFIFO()               : n(0), list() {}	// Default constructor
    CNQueueFIFO(CNParam *param) : n(0), list() {}	// CNParam constructor

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_QUEUEFIFO;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_QUEUEFIFO ? TRUE : CNQueue::is_a(desc);
    };
        
    static CNQueueFIFO *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNQueueFIFO *)obj;
#   else
	return (CNQueueFIFO *)( !obj || obj->is_a(CN_QUEUEFIFO)
	       ? obj : fatal_type(obj->class_desc(), CN_QUEUEFIFO) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNQueueFIFO(param) : new CNQueueFIFO; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__QueueFIFO_h**/
