//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: QueueFIFO.c,v 0.19 1994/01/28 18:54:15 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNQueueFIFO --- FIFO queue, n_w = \infty (almost)
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "QueueFIFO.h"



bool CNQueueFIFO::empty() const
{
    return n == 0;
}



bool CNQueueFIFO::full() const
{
    return FALSE;
}



int CNQueueFIFO::length() const
{
    return n;
}



void CNQueueFIFO::put(CNObject *obj)
{
    list.append(obj);
    n++;
}



CNObject *CNQueueFIFO::get()
{
    CNDLObject *pos;
    CNObject *obj;
    
    pos = list.first();
    if(pos)
    {
	obj = pos->object();
	list.delete_object(pos);
	n--;
    }
    else
	obj = NIL;
    
    return obj;
}



void CNQueueFIFO::delete_all()
{
    list.delete_all();
    n = 0;
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNQueueFIFO::print(ostream &strm) const
{
    strm << "length=" << n << endl;
    list.print(strm);
}

// Debug output
void CNQueueFIFO::dump(ostream &strm) const
{
    strm << "CNQueueFIFO { $Revision: 0.19 $" << endl
	 << "length=" << n << endl;
    list.dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNQueueFIFO
static CNClass CNQueueFIFO_desc("CNQueueFIFO", "$Revision: 0.19 $",
			    CNQueueFIFO::new_object);

// "Type" for type checking functions
CNClassDesc CN_QUEUEFIFO = &CNQueueFIFO_desc;






