//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Manager.h,v 0.19 1994/01/28 18:54:15 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNManager --- object management frontend
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __Manager_h
#define __Manager_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_MANAGER;	// CNClass CNManager description

#include <CNCL/HashDynamic.h>
#include <CNCL/KeyString.h>
#include <string.h>

const char EOS = '\0';
const char SLASH = '/';
const unsigned long DEFAULT_CAPACITY = 17;

/*
 * The class CNManager
 */

class CNManager : public CNObject
{
    char *name;
//    CNHashDynamic *table;
//  gcc 2.5.4 didn't find CNHashTable::get_key(CNKey &)
    CNHashTable *table;

public:
    CNObject *new_object(char *object_name, CNClassDesc desc, CNParam *param = NIL);
    bool delete_object(char *object_name);
    CNObject *get_object(char *object_name) const;
    char *get_name() const
    {
	return name;
    }
    bool is_empty() const;
    
    /***** Constructors ******************************************************/
public:
    CNManager(char *object_name = NIL);                 // Default constructor
    CNManager(CNParam *param);			      // CNParam constructor
    ~CNManager();

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_MANAGER;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_MANAGER ? TRUE : CNObject::is_a(desc);
    };
        
    static CNManager *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNManager *)obj;
#   else
	return (CNManager *)( !obj || obj->is_a(CN_MANAGER)
	       ? obj : fatal_type(obj->class_desc(), CN_MANAGER) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNManager(param) : new CNManager; }
    
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__Manager_h**/
