//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArrayFloat  --- float array class
 *
 * Created from
 * $Id: T_array.cP,v 0.19 1994/01/28 18:55:33 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "ArrayFloat.h"



/***** Private functions *****************************************************/

void CNArrayFloat::init(int sz)
{
    asize = sz;
    array = new float[sz];
    for (int i = 0; i < sz; i++)
	array[i] = def_val;
}



void CNArrayFloat::delete_array()
{
    asize = 0;
    if(array)
	delete [] array;
    array = NIL;
}



/***** Constructors **********************************************************/

CNArrayFloat::CNArrayFloat(int sz, float def)
{
    if (sz<0)
	fatal(NIL, "CNArrayFloat: ", "invalid size < 0");
    
    def_val = def;
    init(sz);
}



CNArrayFloat::CNArrayFloat(const CNArrayFloat &a)
{
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
}


CNArrayFloat::~CNArrayFloat()
{
    CNArrayFloat::delete_array();
}



CNArrayFloat &CNArrayFloat::operator = (const CNArrayFloat &a)
{
    delete_array();
    init(a.asize);
    for (int i = 0; i < asize; i++)
	array[i] = a.array[i];
    return *this;
}
    


/***** public functions ******************************************************/

void CNArrayFloat::size(int sz)  // Set size of array
{
    if (sz<0)
	fatal(NIL, "CNArrayFloat: ", "invalid size < 0");

    if (array == NIL)
	init(sz);
    else if (sz != asize)
    {
	float *temp = array;
	array = new float[sz];
	for (int i = 0; i < sz; i++)
	    if (i < asize)
		array[i] = temp[i];
	    else
		array[i] = def_val;
	delete[] temp;
	asize = sz;
    }
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNArrayFloat::print(ostream &strm) const
{
    strm << "[ ";
    for(int i=0; i<asize; i++)
    {
	strm << array[i];
	if(i != asize-1)
	    strm << ", ";
    }
    strm << " ]";
}

// Debug output
void CNArrayFloat::dump(ostream &strm) const
{
    strm << "CNArrayFloat { $Revision: 0.19 $" << endl;
    strm << "size=" << asize
	 << " array=" << hex << (unsigned long)(array) << dec << endl;
    strm << "values=" << this << endl;
    strm << "}" << endl;
}



/***** CNCL stuff for type ***************************************************/

// Describing object for class CNArrayFloat
static CNClass CNArrayFloat_desc("CNArrayFloat", "$Revision: 0.19 $",
			    CNArrayFloat::new_object);

// "Type" for type checking functions
CNClassDesc CN_ARRAYFLOAT = &CNArrayFloat_desc;
