//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArray2Long  --- long array class
 *
 * Created from
 * $Id: T_array2.hP,v 0.19 1994/01/28 18:55:33 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNArray2Long_h
#define __CNArray2Long_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Array2.h>
#include <CNCL/ArrayLong.h>

extern CNClassDesc CN_ARRAY2LONG;	// CNClass CNArray2Long description


/*
 * The class CNArray2Long
 */


class CNArray2Long : public CNArray2
{
  public:	/***** Public interface **************************************/
    virtual void size(int r, int c);

    void put(int r, int c, long value)// Put value into array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	    range_error(r, c);
	else
#   endif
	    array[r][c] = value;
    }

    long get(int r, int c) const	// Get value from array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	{   range_error(r, c); return 0; }
	else
#   endif
	    return array[r][c];
    }

    CNArrayLong& operator[] (int index)	// Operator []
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || arows<=index)
	    range_error(index);
#   endif
	return array[index];
    }

  private:	/***** Internal private members ******************************/
    CNArrayLong *array;		// Array of array of long
    long def_val;			// Default value
    
    void init(int r, int c);		// Initialize array
    void delete_array();                // Delete array

  public:	/***** Constructors ******************************************/
    CNArray2Long()               : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Long(CNParam *param) : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Long(int r, int c, long def=0);
    CNArray2Long(const CNArray2Long &a);		// Copy constructor

    ~CNArray2Long();

    CNArray2Long &operator = (const CNArray2Long &a);
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAY2LONG; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAY2LONG ? TRUE : CNArray2::is_a(desc); }
        
    static CNArray2Long *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray2Long *)obj;
#   else
	return (CNArray2Long *)( !obj || obj->is_a(CN_ARRAY2LONG)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY2LONG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNArray2Long(param) : new CNArray2Long; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNArray2Long_h**/
