//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: Array2 --- Base class for 2-dimensional arrays
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Array2_h
#define __Array2_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_ARRAY2;	// Class Array2 description


/*
 * The class Array2
 */

class CNArray2 : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNArray2()                       : arows(0), acols(0) {}
    CNArray2(CNParam *param)         : arows(0), acols(0) {}
    CNArray2(unsigned r, unsigned c) : arows(r), acols(c) {}

  public:	/***** Public interface **************************************/
    unsigned get_rows() const { return arows; }		// Return rows
    unsigned get_cols() const { return acols; }		// Return cols
    unsigned rows()     const { return arows; }
    unsigned cols()     const { return acols; }

    virtual void size(int r, int c) = 0;		// Resize array
    void set_size(int r, int c) { size(r, c); }

    
  private:	/***** Internal private members ******************************/

  protected:
    unsigned arows, acols;				// Rows, columns
    void range_error(int index) const;
    void range_error(int r, int c) const;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAY2; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAY2 ? TRUE : CNObject::is_a(desc); }
        
    static CNArray2 *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray2 *)obj;
#   else
	return (CNArray2 *)( !obj || obj->is_a(CN_ARRAY2)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY2) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};

#endif /**__Array2_h**/
