//:ts=8  -*- C++ -*-
/**BHEADER*********************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Object.c,v 0.19 1994/01/28 18:51:42 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNObject --- Base of CNCL inheritance
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "CNCL.h"
#include "Object.h"
#include "Class.h"



/*
 * Special error function called by XX::cast_from_object() if an
 * invalid type cast is requested.
 *
 * This function actually terminates the program, the return value
 * is not used, but necessary for the cast_from_object() function.
 */
CNObject *CNObject::fatal_type(CNClassDesc from, CNClassDesc to)
{
    fatal(NIL, "invalid type cast: ", from->name(), " -> ", to->name() );
    return NIL;
}



/*
 * Utility functions to print out objects
 */

ostream &operator << (ostream &strm, const CNObject &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNObject *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



// Describing object for class CNObject
static CNClass CNObject_desc("CNObject", "$Revision: 0.19 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_OBJECT = &CNObject_desc;
