//:ts=8  -*- C++ -*-
/**BHEADER*******************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Class.c,v 0.19 1994/01/28 18:51:42 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNClass --- CNClass description class
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "Class.h"


// Describing object for class CNClass
static CNClass CNClass_desc("CNClass", "$Revision: 0.19 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_CLASS = &CNClass_desc;



// Create objects via CLASS::new_object()

CNObject *CNClass::new_object(CNParam *param) const
{
    if(c_func)
	return c_func(param);
    fatal(NIL, "can't create objects of class ", name());
    return NIL;
}

CNObject *CNClass::new_object(CNParam &param) const
{
    return new_object(&param);
}



// Output

void CNClass::print(ostream &strm) const
{
    strm << c_name << ", " << c_version << endl;
}


void CNClass::dump(ostream &strm) const
{
    strm << "CNClass { " << c_name << ", " << c_version << " }" << endl;
}
