//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Queue.h,v 0.19 1994/01/28 18:54:15 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNQueue --- Abstract queue base class
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Queue_h
#define __Queue_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_QUEUE;	// CNClass CNQueue description


/*
 * The class CNQueue
 */

class CNQueue : public CNObject
{
public:
    virtual bool empty() const = 0;	// Is queue empty?
    virtual bool full()  const = 0;	// Is queue full?
    virtual int  length() const = 0;	// Length of queue
    virtual void put(CNObject *obj) = 0;	// Put object into queue
    virtual CNObject *get() = 0;		// Get object from queue
    virtual void delete_all() = 0;	// Delete all objects in queue

    void put(CNObject &obj);		// Put object into queue

    /***** Constructors ******************************************************/
public:
    CNQueue() {}				// Default constructor
    CNQueue(CNParam *param) {}		// CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_QUEUE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_QUEUE ? TRUE : CNObject::is_a(desc);
    };
        
    static CNQueue *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNQueue *)obj;
#   else
	return (CNQueue *)( !obj || obj->is_a(CN_QUEUE)
	       ? obj : fatal_type(obj->class_desc(), CN_QUEUE) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__Queue_h**/
