//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Object.h,v 0.19 1994/01/28 18:51:42 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNObject --- Base of CNCL inheritance
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Object_h
#define __Object_h


#include <CNCL/CNCL.h>


class CNClass;



/*
 * CNClass description type
 */

typedef const CNClass * const CNClassDesc;


/*
 * Type description of class CNObject
 */

extern CNClassDesc CN_OBJECT;



/*
 * Base class CNObject:
 *   Root of CNCL inheritance hierarchy
 */

class CNObject : public CNCL
{
  public:
    // Return class description
    virtual CNClassDesc class_desc() const
    {
	return CN_OBJECT;
    }
        
    // Type checking
    virtual bool is_a(CNClassDesc desc) const
    {
	return desc == CN_OBJECT;
    }
        
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;

    // Special error function for XX:cast_from_object()
  protected:
    static CNObject *fatal_type(CNClassDesc from, CNClassDesc to);
};



/*
 * Utility functions to print out objects
 */

ostream &operator << (ostream &strm, const CNObject &obj);
ostream &operator << (ostream &strm, const CNObject *obj);


#endif /**__Object_h**/
