//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: LCG.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNLCG --- Linear congruence random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __LCG_h
#define __LCG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/RNG.h>		// Base class

extern CNClassDesc CN_LCG;	// CNClass CNLCG description



/*
 * The class CNLCG --- Linear Congruential Generator
 */

class CNLCG : public CNRNG
{
public:
    virtual unsigned long as_long32();
    virtual void reset();
    virtual bool has_long32() {return FALSE;}
    
    unsigned long seed();
    void seed(unsigned long);

    // Private members
private:
    unsigned long initialSeed;
    unsigned long state;

    /***** Constructors ******************************************************/
public:
    CNLCG(unsigned long seed = 929);
    CNLCG(CNParam *param) {}			// CNParam constructor

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_LCG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_LCG ? TRUE : CNRNG::is_a(desc);
    };
        
    static CNLCG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNLCG *)obj;
#   else
	return (CNLCG *)( !obj || obj->is_a(CN_LCG)
	       ? obj : fatal_type(obj->class_desc(), CN_LCG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNLCG(param) : new CNLCG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline unsigned long CNLCG::seed()
{
    return(state);
}

inline void CNLCG::seed(unsigned long s)
{
    initialSeed = s;
    reset();
}

#endif /**__LCG_h**/
