//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: InterTab.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNInterTab --- CNRandom numbers from table
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __InterTab_h
#define __InterTab_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Tab.h>		// Base class

extern CNClassDesc CN_INTERTAB;	// CNClass CNInterTab description



/*
 * The class CNInterTab
 */

class CNInterTab : public CNTab
{
public:
    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNInterTab();   				// Default constructor
    CNInterTab(CNParam *param); 			// CNParam constructor
    CNInterTab(double *address, long length, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_INTERTAB;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_INTERTAB ? TRUE : CNTab::is_a(desc);
    };
        
    static CNInterTab *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNInterTab *)obj;
#   else
	return (CNInterTab *)( !obj || obj->is_a(CN_INTERTAB)
	       ? obj : fatal_type(obj->class_desc(), CN_INTERTAB) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNInterTab(param) : new CNInterTab; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNInterTab::CNInterTab(double *address, long length, CNRNG *gen)
    : CNTab(address,length,gen)
{}

inline CNInterTab::CNInterTab ()
    : CNTab(0,0,0)
{}

inline CNInterTab::CNInterTab(CNParam *param)
    : CNTab(0,0,0)
{}


#endif /**__InterTab_h**/
