//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FileG.h,v 0.19 1994/01/28 18:54:32 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNFileG --- File random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __FileG_h
#define __FileG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/RNG.h>		// Base class

extern CNClassDesc CN_FILEG;	// CNClass CNFileG description


/*
 * The class CNFileG
 */

class CNFileG : public CNRNG
{
public:
    virtual unsigned long as_long32();
    virtual void reset();
    virtual bool has_long32() {return TRUE;}
    void newfile(char *, bool par=FALSE);
    unsigned int wrong_parity(){ return wrong_parity_count; }
    
private:
    void read_buffer();
    unsigned long remaining_data();
        
    // Private members
private:
	 enum { PURAN2_BUF_SIZE=    1024,     // size constants for handling
			  PURAN2_PAR_BUF_SIZE=1088,     // Puran2 parity files
			  PURAN2_BLCK_SIZE=    128,
			  PURAN2_PAR_SIZE=       8,
			  PURAN2_PAR_BLCK_SIZE=(PURAN2_BLCK_SIZE+PURAN2_PAR_SIZE)};
    
    char *name;
    FILE *fp;
    long count; // parity 0 only
    
    int parity;
    unsigned int wrong_parity_count;
    unsigned long file_length;
    unsigned char parity_bit[256];
    unsigned long long_max_count;
    unsigned long long_count;
    unsigned long buffer[PURAN2_BUF_SIZE];
    
    /***** Constructors ******************************************************/
public:
    CNFileG();      				// Default constructor
    CNFileG(CNParam *param);			// CNParam constructor
    CNFileG(char *, bool par=FALSE);
    ~CNFileG();

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FILEG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FILEG ? TRUE : CNRNG::is_a(desc);
    };
        
    static CNFileG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFileG *)obj;
#   else
	return (CNFileG *)( !obj || obj->is_a(CN_FILEG)
	       ? obj : fatal_type(obj->class_desc(), CN_FILEG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFileG(param) : new CNFileG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__FileG_h**/
