//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSetArray.h,v 0.19 1994/01/28 18:55:53 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSetArray --- Fuzzy set based on array with membership values
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFSetArray_h
#define __CNFSetArray_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/FSet.h>		// Base class
#include <CNCL/ArrayDouble.h>

extern CNClassDesc CN_FSETARRAY;	// Class CNFSetArray description


/*
 * The class CNFSetArray
 */

class CNFSetArray : public CNFSet
{
public:
					// Get membership values for x
    virtual double get_membership(double x) const;
					// Compute center of gravity
    virtual double center_of_gravity(double min, double max) const;

    double get(int i) const;		// Get value from array
    void put(int i, double x);		// Put value into array
    double &operator [] (int i);	// Access array via []
    int get_n() const;

    // Private members
private:
    CNArrayDouble val;			// Array with membership values
    double xmin, xmax;			// Limits

    /***** Constructors ******************************************************/
public:
    CNFSetArray();
    CNFSetArray(int sz, double min, double max);
    CNFSetArray(CNParam *param);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FSETARRAY;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FSETARRAY ? TRUE : CNFSet::is_a(desc);
    };
        
    static CNFSetArray *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFSetArray *)obj;
#   else
	return (CNFSetArray *)( !obj || obj->is_a(CN_FSETARRAY)
	       ? obj : fatal_type(obj->class_desc(), CN_FSETARRAY) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFSetArray(param) : new CNFSetArray; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFSetArray_h**/
