//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDPushButton.h,v 0.19 1994/01/28 18:55:41 cncl-adm Exp cncl-adm $
 *
 * Class: EZDPushButton --- Interface to ezd push-button
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZDPushButton_h
#define __EZDPushButton_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZD.h>		// Base class

extern CNClassDesc CN_EZDPUSHBUTTON;	// Class EZDPushButton description


/*
 * The class EZDPushButton
 */

class EZDPushButton : public EZD
{
public:
    void set_text(const CNString &t) { text = t; }

    // Private members
private:
    int x, y, w, h;
    CNString text;
    CNString action;

    void initialize();
    
    /***** Constructors ******************************************************/
public:
    EZDPushButton()
	: EZD("button"), x(0), y(0), w(50), h(20),
	  text("button"), action("(log-event)") { initialize(); }
    EZDPushButton(CNParam *param)
	: EZD("button"), x(0), y(0), w(50), h(20),
	  text("button"), action("(log-event)") { initialize(); }
    EZDPushButton(const CNString &name, int vx, int vy, int vw, int vh,
		  const CNString &vtext)
	: EZD(name), x(vx), y(vy), w(vw), h(vh),
	  text(vtext), action("(log-event)")    { initialize(); }
    EZDPushButton(const CNString &name, int vx, int vy, int vw, int vh,
		  const CNString &vtext, const CNString &vaction)
	: EZD(name), x(vx), y(vy), w(vw), h(vh),
	  text(vtext), action(vaction)          { initialize(); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDPUSHBUTTON;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDPUSHBUTTON ? TRUE : EZD::is_a(desc);
    };
        
    static EZDPushButton *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDPushButton *)obj;
#   else
	return (EZDPushButton *)( !obj || obj->is_a(CN_EZDPUSHBUTTON)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDPUSHBUTTON) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDPushButton(param) : new EZDPushButton; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDPushButton_h**/
