//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: DLIterator.h,v 0.19 1994/01/28 18:54:15 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNDLIterator --- Double linked list iterator
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __DLIterator_h
#define __DLIterator_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_DLITERATOR;	// CNClass CNDLIterator description

#include <CNCL/DLList.h>



/*
 * The class CNDLIterator
 */

class CNDLIterator : public CNObject
{
public:
    // Reset iterator
    void reset(const CNDLList *new_list)
    {
	list = new_list;
	reset();
    }
    void reset(const CNDLList &new_list)
    {
	list = &new_list;
	reset();
    }
    void reset()
    {
	pnt   = list->first();
    }

    // Get object from actual list position
    CNObject *get_object()
    {
	return pnt ? pnt->get_object() : NIL;
    }
    CNObject *object()
    {
	return pnt ? pnt->get_object() : NIL;
    }

    // Get position (CNDLObject *) in CNDLList
    CNDLObject *position()
    {
	return pnt;
    }
    CNDLObject *get_position()
    {
	return pnt;
    }

    // Move pointer to first object, retrieve current object
    CNObject *first_object()
    {
	pnt = list ? list->first() : NIL;
	return pnt ? pnt->object() : NIL;
    }
    CNObject *first()
    {
	pnt = list ? list->first() : NIL;
	return pnt ? pnt->object() : NIL;
    }
    	    
    // Move pointer to last object, retrieve current object
    CNObject *last_object()
    {
	pnt = list ? list->last() : NIL;
	return pnt ? pnt->object() : NIL;
    }
    CNObject *last()
    {
	pnt = list ? list->last() : NIL;
	return pnt ? pnt->object() : NIL;
    }
    	    
    // Advance pointer to next object, retrieve current object
    CNObject *next_object()
    {
	CNDLObject *p;
	p = pnt;
	if(pnt)
	    pnt = pnt->next();
	return p ? p->object() : NIL;
    }
    CNObject *next()
    {
	return next_object();
    }
    CNObject *operator++()		// Prefix ++arg
    {
	return next_object();
    }
    CNObject *operator++(int)		// Postfix arg++ (C++ 3.0)
    {
	return next_object();
    }

    // Move pointer to previous object, retrieve current object
    CNObject *prev_object()
    {
	CNDLObject *p;
	p = pnt;
	if(pnt)
	    pnt = pnt->prev();
	return p ? p->object() : NIL;
    }
    CNObject *prev()
    {
	return prev_object();
    }
    CNObject *operator--()		// Prefix --arg
    {
	return prev_object();
    }
    CNObject *operator--(int)		// Postfix arg-- (C++ 3.0)
    {
	return prev_object();
    }

    // Private members
private:
    const CNDLList *list;			// CNDLList iterated on
    CNDLObject *pnt;			// Actual position in CNDLList
    
    /***** Constructors ******************************************************/
public:
    CNDLIterator() : list(NIL), pnt(NIL) {}	// Default constructor
    CNDLIterator(const CNDLList *new_list)
    {
	reset(new_list);
    }
    CNDLIterator(const CNDLList &new_list)
    {
	reset(&new_list);
    }
    CNDLIterator(CNParam *param) : list(NIL), pnt(NIL) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_DLITERATOR;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_DLITERATOR ? TRUE : CNObject::is_a(desc);
    };
        
    static CNDLIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNDLIterator *)obj;
#   else
	return (CNDLIterator *)( !obj || obj->is_a(CN_DLITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_DLITERATOR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNDLIterator(param) : new CNDLIterator; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__DLIterator_h**/
