//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Coord.h,v 0.19 1994/01/28 18:55:13 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNCoord --- 2-dim coordinates
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Coord_h
#define __Coord_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

#include <CNCL/ICoord.h>

extern CNClassDesc CN_COORD;	// CNClass CNCoord description



/*
 * The class CNCoord
 */

class CNCoord : public CNObject
{
    friend class CNICoord;
    
private:
    static double scale;

public:
    double x, y;

    CNCoord &operator += (const CNCoord &v);
    CNCoord &operator -= (const CNCoord &v);

    static double set_scale(double new_scale);
    static double get_scale();

    /***** Constructors ******************************************************/
public:
    CNCoord();
    CNCoord(CNParam *param);
    CNCoord(double vx, double vy);
    CNCoord(const CNICoord &v);
    CNCoord(const CNCoord &v);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_COORD;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_COORD ? TRUE : CNObject::is_a(desc);
    };
        
    static CNCoord *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNCoord *)obj;
#   else
	return (CNCoord *)( !obj || obj->is_a(CN_COORD)
	       ? obj : fatal_type(obj->class_desc(), CN_COORD) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNCoord(param) : new CNCoord; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



CNCoord operator + (const CNCoord &a, const CNCoord &b);
CNCoord operator - (const CNCoord &a, const CNCoord &b);


#endif /**__Coord_h**/
