#!/usr/global/bin/perl
#
# $Id: CNarray.pl,v 0.19 1994/01/28 18:51:37 cncl-adm Exp cncl-adm $
#
# Perl script to generate CNCL class from template files
#
$TEMPL_DIR  = "<INCDIR>/CNCL";
$TEMPL_NAME = "T_array";

$local = 0;
$pointer = 0;

require "getopts.pl";

&Getopts("lt:p");

if($opt_t) {
    $TEMPL_DIR = $opt_t;
}

if($opt_l) {
    $local = 1;
}

if($opt_p) {
    $pointer = 1;
}

if($#ARGV < 0) {
    print STDERR "usage: CNarray [-p] [-l] [-t template-dir] type\n";
    exit 1;
}



$type  = $ARGV[0];

$xx    = $type;
$xx    =~ s/^CN//;

$name  = substr($xx, 0, 1);
$name  =~ tr/[a-z]/[A-Z]/;
$name  = $name.substr($xx, 1, length($xx)-1);

$file  = "Array$name";

$class = "CNArray$name";

$desc  = "CN_ARRAY$name";
$desc  =~ tr/[a-z]/[A-Z]/;

$pnt   = "CN$name"."Ptr";
$pnt   =~ s/Object/Obj/;

$stype = $pointer ? $pnt : $type;


open(INH, "$TEMPL_DIR/$TEMPL_NAME.hP" )
    || die "CNCLgenclass: can't access $TEMPL_NAME.hP\n";
open(INC, "$TEMPL_DIR/$TEMPL_NAME.cP" )
    || die "CNCLgenclass: can't access $TEMPL_NAME.cP\n";

open(OUTH, ">$file.h")
    || die "CNCLgenclass: can't open $file.h\n";
open(OUTC, ">$file.c")
    || die "CNCLgenclass: can't open $file.c\n";


while(<INH>) {
    if( /^<<TYPEDEF/ ) {
	if($pointer) {
	    print OUTH "typedef $type *$pnt;\n";
	}
	next;
    }

    s/%%/$/g;
    s/<CLASS>/$class/g;
    s/<DESC>/$desc/g;
    s/<TYPE>/$stype/g;
    s/<FILE>/$file/g;

    print OUTH $_;
}

while(<INC>) {
    if( /^<<TYPEDEF/ ) {
	if($pointer) {
	    print OUTC "typedef $type *$pnt;\n";
	}
	next;
    }

    s/%%/$/g;
    s/<CLASS>/$class/g;
    s/<DESC>/$desc/g;
    s/<TYPE>/$stype/g;
    s/<FILE>/$file/g;

    print OUTC $_;
}

close(INH);
close(INC);
close(OUTH);
close(OUTC);
