10 REM Program to generate test knowledge bases for M1
20 REM Larry Press, (213) 475-6515, ARPA SWG.LPRESS@C.ISI.EDU
30 REM Variables used:
40 REM ---------------------------------------------------------------------
50 REM RW       rule width
60 REM NR       number of body rules to generate
70 REM RT$      rule type " and " or " or "
80 REM PR$      premise portion of the rule being generated
90 REM KBNAME$  output file name, contains test knowledge base
100 REM BV	beginning variable of current premise
110 REM 	single character variables are temporary
120 REM ---------------------------------------------------------------------
130 REM main program
140 REM --------------------------------------------------------------------
150 GOSUB 200  'prompt user for inputs
160 GOSUB 460  'generate the goal and final rules
170 GOSUB 540  'generate the body rules
180 STOP
190 REM --------------------------------------------------------------------
200 REM Prompt user for inputs
210 REM --------------------------------------------------------------------
220 INPUT "What is the name of the knowledge base: ", KBNAME$
230 OPEN KBNAME$ + ".kbs" FOR OUTPUT AS #1
240 INPUT "Simple, Conjunctive or Disjunctive (S/D/C): ", T$
250 RT$ = ""
260 IF T$ = "s" OR T$ = "S" THEN RT$ = " "
270 IF T$ = "c" OR T$ = "C" THEN RT$ = " and "
280 IF T$ = "d" OR T$ = "D" THEN RT$ = " or "
290 IF RT$ = "" THEN PRINT: PRINT "Answer S, D or C only" :PRINT: GOTO 240
300 IF RT$= " " THEN RW = 1: GOTO 320 '  simple rules have only one variable
310 INPUT "How many variables in each premise: ", RW
320 INPUT "How many body rules: ", NR
330 IF NR MOD RW = 0 THEN RETURN
340 PRINT: PRINT "The number of body rules must be an even"
350 PRINT "multiple of the number of variables.": PRINT: GOTO 310
360 REM --------------------------------------------------------------------
370 REM generate a premise of width RW, type RT$, beginning with variable BV
380 REM --------------------------------------------------------------------
390 PR$ = "if "
400 FOR I = 0 TO RW-1
410    PR$ = PR$ + "v" + RIGHT$ (STR$(BV+I), LEN(STR$(BV+I)) - 1) + " = t"
420    IF I<>RW-1 THEN PR$ = PR$ + RT$
430 NEXT I
440 RETURN
450 REM --------------------------------------------------------------------
460 REM generate the goal and final-variable rules
470 REM --------------------------------------------------------------------
480 PRINT #1, "actions find v0;"
490 FOR I = 1 TO RW
500     PRINT #1, "rule" + STR$(I) + " if v" + RIGHT$( STR$ (NR+I), LEN (STR$(NR+I))-1) + " = unknown then v" + RIGHT$( STR$ (NR+I), LEN (STR$(NR+I))-1) + " = t;"
510 NEXT I
520 RETURN
530 REM --------------------------------------------------------------------
540 REM generate the body of the knowledge base
550 REM --------------------------------------------------------------------
560 FOR R = 0 TO NR
570    IF R = 0 THEN BV = 1: GOSUB 370: GOTO 590 '            the goal rule
580    IF (R-1) MOD RW = 0 THEN BV = R + RW: GOSUB 370
590    PRINT #1, "rule" + STR$(R+1+RW) + " " + PR$ + " then " + "v" + RIGHT$ (STR$(R), LEN(STR$(R))-1) + " = t;"
600 NEXT R
610 RETURN
620 END
